#define  RSA_MIN_PRIMESIZE     8
#define  RSA_MAX_PRIMESIZE   128

#define  RSA_PRIME_TEST_START    1
#define  RSA_FERMAT_TEST_FAIL    2
#define  RSA_FERMAT_TEST_OK      3
#define  RSA_FIND_ED_START       4
#define  RSA_KEYS_TEST_START     5
#define  RSA_GEN_END             6

typedef struct TagRSADATA {
  char IData[3456];
} RSADATA;

extern BOOL __syscall RsaInit( RSADATA* Ctx, int KeySize );
/*
  KeySize is a size of N, E and D in bytes.
  Returns TRUE -ok, FALSE -error.
*/

typedef BOOL (__syscall *TRsaGenKeysShowFunc)( int Code );
typedef BYTE (__syscall *TRsaRandomFunc)( void* Ctx );

extern BOOL __syscall RsaGenKeys( RSADATA* Ctx, void* Nn, void* Ee, void* Dd,
                                  TRsaGenKeysShowFunc ShowFunc,
                                  TRsaRandomFunc RandomFunc,
                                  void* RandomCtx );
/*
  Calculates RSA key components.
  Uses DRandomize, DRandom.
  Returns TRUE -ok, FALSE -aborted.

  ShowFunc: function ShowFunc( Code: integer ): boolean; cdecl;

  shows key generation process.
  Returns FALSE to abort generation, TRUE to continue.
  Codes defined above in const section.
*/

extern void __syscall RsaCrypt( RSADATA* Ctx,
                                void* Block, void* Nn, void* EeDd );
/*
  Computes Block ^ EeDd % Nn.
  Number Block must be less than number Nn, EeDd > 1.
*/
